PACKAGE ohms_law IS
  TYPE current IS RANGE 0 TO 1000000
    UNITS
      ua;              -- micro amps
      ma = 1000 ua;    -- milli amps
      a  = 1000 ma;    -- amps
    END UNITS;

  TYPE voltage IS RANGE 0 TO 1000000
    UNITS
      uv;              -- micro volts
      mv = 1000 uv;    -- milli volts
      v  = 1000 mv;    -- volts
    END UNITS;

  TYPE resistance IS RANGE 0 TO 100000000
    UNITS
      ohm;             -- ohms
      Kohm = 1000 ohm; -- kilo ohms
      Mohm = 1000 Kohm;-- mega ohms
    END UNITS;
END ohms_law;

use work.ohms_law.all;
ENTITY calc_resistance IS
  PORT( i : IN current; e : IN voltage;
        r : OUT resistance);
END calc_resistance;

ARCHITECTURE  behave OF calc_resistance IS
BEGIN
  ohm_proc: PROCESS( i, e )
    VARIABLE convi, conve, int_r : integer;
  BEGIN
    convi := current'POS(i); -- current in ua
    conve := voltage'POS(e); -- voltage in uv

    -- resistance in ohms
    int_r := conve / convi;
 
    r <= resistance'VAL(int_r);

    -- another way to write this example 
    -- is shown below
    -- r <=resistance'VAL(current'POS(i)
    -- / voltage'POS(e));

  END PROCESS;
END behave;

